﻿#pragma once

// Derived class allocations will be 16-byte aligned (for SSE intrinsics)
class Align16
{
public:
	static void* operator new (size_t size) throw (...) {
		void * p = _aligned_malloc(size, 16);
		if (p == 0)  throw std::bad_alloc();
		return p; 
	}

	static void operator delete (void *p) {
		_aligned_free(p);
	}
protected:
	Align16() {}
	~Align16() {}
};

